#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// zoomed maze in 3DMod01.fsh   by   skal  
//https://www.shadertoy.com/view/ctGGDz
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
https://twitter.com/kamoshika_vrc/status/1656260144840478720
float i,c=15./PI,d=c,g;
for(;i++<99.&&d>1e-4;g+=d){
  vec3 P=normalize(vec3(FC.xy-r*.5,-r.y))*rotate3D(.9,FC.wzz)*g;
  P.yz+=1.;
  vec2 I=ceil(P.xz=vec2(log(d=length(P.xz))-t,atan(P.z,P.x))*c);
  P.xz-=I;
  d=max(P.y,(.4-abs(fract((fsnoise(I)<.5?-P.z:P.z)-P.x)-.5))*.7*d/c);
}
o+=9./i;
*/

vec3 axis_rotation(vec3 P, vec3 Axis, float angle) {
  Axis = normalize(Axis);
  return mix(Axis * dot(P, Axis), P, cos(angle)) + sin(angle) * cross(P, Axis);
}

float fsnoise(vec2 v) {
  return fract(sin(dot(v, vec2(12.9898, 78.233))) * 43758.5453);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
  vec3 uv = normalize(vec3(fragCoord.xy - 0.5 * iResolution.xy, -iResolution.y));
  vec3 dir = axis_rotation(uv, vec3(2.,1.,1.), .9);  // view direction
  vec3 Po = vec3(0., 1., 1.);  // view origin
  float wall_thickness = 0.4;
  float scale = 4.0;
  float luminosity = 0.5;
  float steps = 0., distance = 0.;
  while (++steps < 99.) {
    vec3 P = Po + dir * distance;
    float l = length(P.xz);
    // https://www.osar.fr/notes/logspherical/
    // switch to 'polar' log-spherical coordinates
    P.xz = vec2(log(l) - iTime, atan(P.z, P.x)) * scale;
    vec2 I = ceil(P.xz);   // integer part = cell ID
    P.xz -= I;  // fractional part
    // the 'maze' itself:
    float v = abs(fract((fsnoise(I) < .5 ? -P.z : P.z) - P.x) - .5);
    v = (wall_thickness - v) * luminosity * l / scale;
    // here, walls are infinitely high, so we cut them with the plane P.y
    l = max(P.y, v);
    // advance the marching
    distance += l;
    if (l < 1e-4) break;
  }
  fragColor = vec4(10. / steps);  // divide by steps => ~AO
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

